package w83b.w83bOperacionesPaso.w83bImpugnaciones;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.commons.lang.StringUtils;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFFooter;
import org.apache.poi.hssf.usermodel.HSSFHeader;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.hssf.util.Region;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

import w83b.w83bBeans.W83bImpugnacionBean;
import w83b.w83bBeans.W83bUsuarioXLNetsBean;
import w83b.w83bOperacionesPaso.w83bMantenimientos.w83bConvenios.W83bTablaConveniosExcelAction;
import w83b.w83bUtilidades.W83bUtilidadesComunes;
import w83b.w83bUtilidades.W83bUtilidadesExcel;
import w83b.w83bUtilidadesComunes.W83bClsConstantes;
import w83b.w83bUtilidadesComunes.W83bDateUtil;
import w83b.w83bUtilidadesComunes.W83bUtilidades;
import es.ejie.frmk.infraestructura.internacionalizacion.Q70GestorMensajesi18n;
import es.ejie.frmk.listeners.base.Q70ListenerUtils;
import es.ejie.frmk.presentacion.operacion.paso.Q70ActionPasoOP;
import es.ejie.frmk.presentacion.sesiondatos.Q70ContextoEJIE;

// TODO: Auto-generated Javadoc
/**
 * The Class W83bTablaConveniosOP.java.
 *
 * @author Deusto Sistemas
 */
public class W83bTablaImpugnacionesExcelAction extends Q70ActionPasoOP{


	
	protected void processOP(Q70ContextoEJIE contexto, ActionErrors errores, ActionMapping mapping,
			ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
		
		
	}

	protected ActionForward processForward(Q70ContextoEJIE contexto, ActionErrors errors, ActionMapping mapping, 
			ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {

		String strRutaExcel = Q70ListenerUtils.getApplicationProperty("RUTA_PLANTILLAS_EXCEL")+"plantillaExcelw83bListadoImpugnaciones.xls";
		InputStream inputStream = W83bTablaConveniosExcelAction.class.getResourceAsStream(strRutaExcel);
		HSSFWorkbook wb = new HSSFWorkbook(inputStream); // Creacin del libro
		wb.setSheetName(0,"Hoja1"); // Creacin de la hoja
        HSSFSheet sheet = wb.getSheetAt(0); // Creacin de la hoja
        
        List lista = (ArrayList)contexto.get("w83bListaImpugnaciones");
        W83bImpugnacionBean impugnacionBean = (W83bImpugnacionBean)contexto.get("w83bImpugnacionTempBean");
        
        W83bUtilidadesExcel excel = new W83bUtilidadesExcel(wb);

        String idioma = (String)contexto.get(W83bClsConstantes.CONSTANTE_CONTEXTO_IDIOMA);
        String aux;
        
        HSSFHeader header = sheet.getHeader();
        header.setRight(W83bDateUtil.getInstance().getLocaleStringFromDate(new Date(), idioma));
        
        HSSFFooter footer = sheet.getFooter();

        footer.setCenter(((W83bUsuarioXLNetsBean)contexto.get(W83bClsConstantes.CONSTANTE_CONTEXTO_USUARIO)).getCalleListadosFormateada());
        footer.setRight(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.label.pag",idioma,new String[]{footer.page()}));
        

        W83bUsuarioXLNetsBean usuario = (W83bUsuarioXLNetsBean)contexto.get(W83bClsConstantes.CONSTANTE_CONTEXTO_USUARIO);
        
        W83bUtilidadesExcel.crearCabeceraPieEstandar(sheet, idioma,(W83bUsuarioXLNetsBean)contexto.get(W83bClsConstantes.CONSTANTE_CONTEXTO_USUARIO));      
        
        HSSFRow row = sheet.createRow((short)1); // Creacin de la fila 1
        HSSFCell cell = row.createCell((short)3);
        HSSFCell cell2;
        HSSFCell cell3;
        row = sheet.getRow((short)4); 
        cell = row.getCell((short)5);
        HashMap datosDelDep=  W83bUtilidadesComunes.obtenerTitulosDelegacionDepartamento(usuario,idioma);
	   
		StringBuffer  tituloImagenEu = (StringBuffer)datosDelDep.get("tituloDepEu");
		StringBuffer  tituloImagenEs = (StringBuffer)datosDelDep.get("tituloDepEs");
		
		cell.setCellValue(tituloImagenEu.toString());
        cell = row.getCell((short)11); 
        cell.setCellValue(tituloImagenEs.toString());
        
        tituloImagenEu = (StringBuffer)datosDelDep.get("tituloDelelegacionEu");
        tituloImagenEs = (StringBuffer)datosDelDep.get("tituloDelelegacionEs");
        
        
        
        row = sheet.getRow((short)6); 
        cell = row.getCell((short)5);
        cell.setCellValue(tituloImagenEu.toString());
        
        cell = row.getCell((short)11); 
        cell.setCellValue(tituloImagenEs.toString());
        
        row = sheet.getRow((short)9); 
        cell = row.getCell((short)0);
       
        StringBuffer titulo = new StringBuffer();
        titulo.append(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.informes.tituloImpugnaciones_eu",idioma));
        titulo.append(" ").append("/").append(" ");
        titulo.append(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.informes.tituloImpugnaciones_es",idioma));
        cell.setCellValue(titulo.toString());
        
       
        //MAPEO FORMULARIO
        int z=11;
      //NUMERO IMPUGNACION
        row = sheet.getRow((short)z); 
        cell = row.createCell((short)0); 
        cell.setCellStyle(excel.styleTextoLabel);
        cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun","comun.impugnaciones.numImpugabr"));
 
        cell = row.createCell((short)1);  
        cell.setCellStyle(excel.styleCadena9Justif);
        StringBuffer nImpugnacionDesde = new StringBuffer();
        StringBuffer nImpugnacionHasta = new StringBuffer();
        
        boolean desde = false;
        
        if(StringUtils.isNotEmpty(impugnacionBean.getNumImpugnacionTerritorioDesde())||
        		StringUtils.isNotEmpty(impugnacionBean.getNumImpugnacionAnyoDesde())||
        		StringUtils.isNotEmpty(impugnacionBean.getNumImpugnacionNumeroDesde())){
        	if(StringUtils.isNotEmpty(impugnacionBean.getNumImpugnacionNumeroDesde()))
        	{
        		aux=W83bUtilidades.rellenarCaracter(impugnacionBean.getNumImpugnacionNumeroDesde(),String.valueOf(W83bClsConstantes.ZERO),W83bClsConstantes.SEIS,true);
        	}else{
        		aux="-";
        	}
        	if(StringUtils.isNotEmpty(impugnacionBean.getNumImpugnacionTerritorioDesde())){
        		nImpugnacionDesde.append(W83bUtilidadesExcel.blancoCampoExcel(impugnacionBean.getNumImpugnacionTerritorioDesde())).append("/");
        	}else{
        		nImpugnacionDesde.append(W83bUtilidadesExcel.blancoCampoExcel("-")).append("/");
        	}
        	if(StringUtils.isNotEmpty(impugnacionBean.getNumImpugnacionAnyoDesde())){
        		nImpugnacionDesde.append(W83bUtilidadesExcel.blancoCampoExcel(impugnacionBean.getNumImpugnacionAnyoDesde())).append("/").append(aux);
        	}else{
        		nImpugnacionDesde.append(W83bUtilidadesExcel.blancoCampoExcel("-")).append("/").append(aux);
        	}
        	desde = true;
        }
        if(StringUtils.isNotEmpty(impugnacionBean.getNumImpugnacionTerritorioHasta())||
        		StringUtils.isNotEmpty(impugnacionBean.getNumImpugnacionAnyoHasta())||
        		StringUtils.isNotEmpty(impugnacionBean.getNumImpugnacionNumeroHasta())){
        	if(desde){
        		nImpugnacionHasta.append(" al ");
        	}
        	if(StringUtils.isNotEmpty(impugnacionBean.getNumImpugnacionNumeroHasta()))
        	{
        		aux=W83bUtilidades.rellenarCaracter(impugnacionBean.getNumImpugnacionNumeroHasta(),String.valueOf(W83bClsConstantes.ZERO),W83bClsConstantes.SEIS,true);
        	}else{
        		aux="-";
        	}
        	if(StringUtils.isNotEmpty(impugnacionBean.getNumImpugnacionTerritorioHasta())){
        		nImpugnacionHasta.append(W83bUtilidadesExcel.blancoCampoExcel(impugnacionBean.getNumImpugnacionTerritorioHasta())).append("/");
        	}else{
        		nImpugnacionHasta.append(W83bUtilidadesExcel.blancoCampoExcel("-")).append("/");
        	}
        	if(StringUtils.isNotEmpty(impugnacionBean.getNumImpugnacionAnyoHasta())){
        		nImpugnacionHasta.append(W83bUtilidadesExcel.blancoCampoExcel(impugnacionBean.getNumImpugnacionAnyoHasta())).append("/").append(aux);
        	}else{
        		nImpugnacionHasta.append(W83bUtilidadesExcel.blancoCampoExcel("-")).append("/").append(aux);
        	}
        }
        cell.setCellValue(nImpugnacionDesde.toString() +nImpugnacionHasta.toString() );
        if(!W83bClsConstantes.VACIO.equals(cell.getStringCellValue()))
        		{
        	 		sheet.addMergedRegion(new Region(z,Short.parseShort("1"),z,Short.parseShort("2")));//NOPMD
        		}
       
    	
      //fin NUMERO IMPUGNACION
        //NUMERO PREAVISO
        row = sheet.getRow((short)z); 
        cell = row.createCell((short)3); 
        cell.setCellStyle(excel.styleTextoLabel);
        cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun","comun.impugnaciones.nPreavabr"));
        cell = row.createCell((short)4);  
        cell.setCellStyle(excel.styleCadena9Justif);
        StringBuffer nPreavisoDesde = new StringBuffer();
        StringBuffer nPreavisoHasta = new StringBuffer();
        
        desde = false;
        
        if(StringUtils.isNotEmpty(impugnacionBean.getNumPreavisoTerritorioDesde())||
        		StringUtils.isNotEmpty(impugnacionBean.getNumPreavisoAnyoDesde())||
        		StringUtils.isNotEmpty(impugnacionBean.getNumPreavisoNumeroDesde())){
        	if(StringUtils.isNotEmpty(impugnacionBean.getNumPreavisoNumeroDesde()))
        	{
        		aux=W83bUtilidades.rellenarCaracter(impugnacionBean.getNumPreavisoNumeroDesde(),String.valueOf(W83bClsConstantes.ZERO),W83bClsConstantes.SEIS,true);
        	}else{
        		aux="-";
        	}
        	if(StringUtils.isNotEmpty(impugnacionBean.getNumPreavisoTerritorioDesde())){
        		nPreavisoDesde.append(impugnacionBean.getNumPreavisoTerritorioDesde()).append("/");
        	}else{
        		nPreavisoDesde.append("-").append("/");
        	}        		
        	if(StringUtils.isNotEmpty(impugnacionBean.getNumPreavisoAnyoDesde())){
        		nPreavisoDesde.append(impugnacionBean.getNumPreavisoAnyoDesde()).append("/").append(aux);
        	}else{
        		nPreavisoDesde.append("-").append("/").append(aux);
        	}
        	desde = true;
        }
        if(StringUtils.isNotEmpty(impugnacionBean.getNumPreavisoTerritorioHasta())||
        		StringUtils.isNotEmpty(impugnacionBean.getNumPreavisoAnyoHasta())||
        		StringUtils.isNotEmpty(impugnacionBean.getNumPreavisoNumeroHasta())){
        	if(desde){
        		nPreavisoHasta.append(" al ");
        	}
        	if(StringUtils.isNotEmpty(impugnacionBean.getNumPreavisoNumeroHasta()))
        	{
        		aux=W83bUtilidades.rellenarCaracter(impugnacionBean.getNumPreavisoNumeroHasta(),String.valueOf(W83bClsConstantes.ZERO),W83bClsConstantes.SEIS,true);
        	}else{
        		aux="-";
        	}
        	if(StringUtils.isNotEmpty(impugnacionBean.getNumPreavisoTerritorioHasta())){
        		nPreavisoHasta .append(W83bUtilidadesExcel.blancoCampoExcel(impugnacionBean.getNumPreavisoTerritorioHasta())).append("/");
        	}else{
        		nPreavisoHasta .append("-").append("/");
        	}
        	if(StringUtils.isNotEmpty(impugnacionBean.getNumPreavisoAnyoHasta())){
        		nPreavisoHasta .append(W83bUtilidadesExcel.blancoCampoExcel(impugnacionBean.getNumPreavisoAnyoHasta())).append("/").append(aux);
        	}else{
        		nPreavisoHasta .append("-").append("/").append(aux);
        	}
        }
        cell.setCellValue(nPreavisoDesde.toString() +nPreavisoHasta.toString());
        if(!W83bClsConstantes.VACIO.equals(cell.getStringCellValue()))
		{
	 		sheet.addMergedRegion(new Region(z,Short.parseShort("4"),z,Short.parseShort("6")));//NOPMD
		}
      //fin NUMERO PREAVISO
        //FECHA DE IMPUGNACION
        row = sheet.getRow((short)z+2); 
        cell = row.createCell((short)0); 
        cell.setCellStyle(excel.styleTextoLabel);
        cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun","comun.impugnaciones.fechaImpugabr"));
        cell = row.createCell((short)1);  
        cell.setCellStyle(excel.styleCadena9Justif);

        StringBuffer fechaImpugnacion = new StringBuffer();
        desde = false;
        if(StringUtils.isNotEmpty(impugnacionBean.getFechaImpugnacionDel())){
        	fechaImpugnacion.append(impugnacionBean.getFechaImpugnacionDel());
        	desde = true;
        }
        if(StringUtils.isNotEmpty(impugnacionBean.getFechaImpugnacionHasta())){
        	if(desde){
        		fechaImpugnacion.append(" - ");
        	}
        	fechaImpugnacion.append(impugnacionBean.getFechaImpugnacionHasta());
        }
        cell.setCellValue(fechaImpugnacion.toString());
        if(!W83bClsConstantes.VACIO.equals(cell.getStringCellValue()))
		{
	 		sheet.addMergedRegion(new Region(z+2,Short.parseShort("1"),z+2,Short.parseShort("2")));//NOPMD
		}
      //fin FECHA DE IMPUGNACION    
        //NUMERO ACTA
        row = sheet.getRow((short)z); 
        cell = row.createCell((short)7); 
        cell.setCellStyle(excel.styleTextoLabel);
        cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun","comun.actas.nActaDH"));
        cell = row.createCell((short)10);  
        cell.setCellStyle(excel.styleCadena9Justif);
        StringBuffer nActaDesde = new StringBuffer();
        StringBuffer nActaHasta = new StringBuffer();
        
        desde = false;
        
        if(StringUtils.isNotEmpty(impugnacionBean.getNumActaTerritorioDesde())||
        		StringUtils.isNotEmpty(impugnacionBean.getNumActaAnyoDesde())||
        		StringUtils.isNotEmpty(impugnacionBean.getNumActaNumeroDesde())){
        	if(StringUtils.isNotEmpty(impugnacionBean.getNumActaNumeroDesde()))
        	{
        		aux=W83bUtilidades.rellenarCaracter(impugnacionBean.getNumActaNumeroDesde(),String.valueOf(W83bClsConstantes.ZERO),W83bClsConstantes.SEIS,true);
        	}else{
        		aux="-";
        	}
        	if(StringUtils.isNotEmpty(impugnacionBean.getNumActaTerritorioDesde())){
        		nActaDesde.append(W83bUtilidadesExcel.blancoCampoExcel(impugnacionBean.getNumActaTerritorioDesde())).append("/");
        	}else{
        		nActaDesde.append("-").append("/");
        	}
        	if(StringUtils.isNotEmpty(impugnacionBean.getNumActaAnyoDesde())){
        		nActaDesde.append(W83bUtilidadesExcel.blancoCampoExcel(impugnacionBean.getNumActaAnyoDesde())).append("/").append(aux);
        	}else{
        		nActaDesde.append("-").append("/").append(aux);
        	}
        	desde = true;
        }
        if(StringUtils.isNotEmpty(impugnacionBean.getNumActaTerritorioHasta())||
        		StringUtils.isNotEmpty(impugnacionBean.getNumActaAnyoHasta())||
        		StringUtils.isNotEmpty(impugnacionBean.getNumActaNumeroHasta())){
        	if(desde){
        		nActaHasta.append(" al ");
        	}
        	if(StringUtils.isNotEmpty(impugnacionBean.getNumActaNumeroHasta()))
        	{
        		aux=W83bUtilidades.rellenarCaracter(impugnacionBean.getNumActaNumeroHasta(),String.valueOf(W83bClsConstantes.ZERO),W83bClsConstantes.SEIS,true);
        	}else{
        		aux="-";
        	}
        	if(StringUtils.isNotEmpty(impugnacionBean.getNumActaTerritorioHasta())){
        		nActaHasta.append(W83bUtilidadesExcel.blancoCampoExcel(impugnacionBean.getNumActaTerritorioHasta())).append("/");
        	}else{
        		nActaHasta.append("-").append("/");
        	}
        	if(StringUtils.isNotEmpty(impugnacionBean.getNumActaAnyoHasta())){
        		nActaHasta.append(W83bUtilidadesExcel.blancoCampoExcel(impugnacionBean.getNumActaAnyoHasta())).append("/").append(aux);
        	}else{
        		nActaHasta.append("-").append("/").append(aux);
        	}
        }
        cell.setCellValue(nActaDesde.toString() +nActaHasta.toString() );
        if(!W83bClsConstantes.VACIO.equals(cell.getStringCellValue()))
		{
	 		sheet.addMergedRegion(new Region(z,Short.parseShort("10"),z,Short.parseShort("13")));//NOPMD
		}
      //fin NUMERO ACTA
        
        //NUMERO LAUDO
        row = sheet.getRow((short)z); 
        cell = row.createCell((short)14); 
        cell.setCellStyle(excel.styleTextoLabel);
        cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun","comun.impugnaciones.nLaudoabr"));
        cell = row.createCell((short)17); 
        cell.setCellStyle(excel.styleCadena9Justif);
        StringBuffer nLaudoDesde = new StringBuffer();
        StringBuffer nLaudoHasta = new StringBuffer();
        
        desde = false;
        
        if(StringUtils.isNotEmpty(impugnacionBean.getNumLaudoTerritorioDesde())||
        		StringUtils.isNotEmpty(impugnacionBean.getNumLaudoAnyoDesde())||
        		StringUtils.isNotEmpty(impugnacionBean.getNumLaudoNumeroDesde())){
        	if(StringUtils.isNotEmpty(impugnacionBean.getNumLaudoNumeroDesde()))
        	{
        		aux=W83bUtilidades.rellenarCaracter(impugnacionBean.getNumLaudoNumeroDesde(),String.valueOf(W83bClsConstantes.ZERO),W83bClsConstantes.TRES,true);
        	}else{
        		aux="-";
        	}
        	if(StringUtils.isNotEmpty(impugnacionBean.getNumLaudoTerritorioDesde())){
        		nLaudoDesde.append(impugnacionBean.getNumLaudoTerritorioDesde()).append("/");
        	}else{
        		nLaudoDesde.append("-").append("/");
        	}
        	if(StringUtils.isNotEmpty(impugnacionBean.getNumLaudoAnyoDesde())){
        		nLaudoDesde.append(impugnacionBean.getNumLaudoAnyoDesde()).append("/").append(aux);
        	}else{
        		nLaudoDesde.append("-").append("/").append(aux);
        	}
        	desde = true;
        }
        if(StringUtils.isNotEmpty(impugnacionBean.getNumLaudoTerritorioHasta())||
        		StringUtils.isNotEmpty(impugnacionBean.getNumLaudoAnyoHasta())||
        		StringUtils.isNotEmpty(impugnacionBean.getNumLaudoNumeroHasta())){
        	if(desde){
        		nLaudoHasta.append(" al ");
        	}
        	if(StringUtils.isNotEmpty(impugnacionBean.getNumLaudoNumeroHasta()))
        	{
        		aux=W83bUtilidades.rellenarCaracter(impugnacionBean.getNumLaudoNumeroHasta(),String.valueOf(W83bClsConstantes.ZERO),W83bClsConstantes.TRES,true);
        	}else{
        		aux="-";
        	}
        	if(StringUtils.isNotEmpty(impugnacionBean.getNumLaudoTerritorioHasta())){
        		nLaudoHasta.append(W83bUtilidadesExcel.blancoCampoExcel(impugnacionBean.getNumLaudoTerritorioHasta())).append("/");
        	}else{
        		nLaudoHasta.append("-").append("/");
        	}
        	if(StringUtils.isNotEmpty(impugnacionBean.getNumLaudoAnyoHasta())){
        		nLaudoHasta.append(W83bUtilidadesExcel.blancoCampoExcel(impugnacionBean.getNumLaudoAnyoHasta())).append("/").append(aux);
        	}else{
        		nLaudoHasta.append("-").append("/").append(aux);
        	}
        }
        cell.setCellValue(nLaudoDesde.toString() +nLaudoHasta.toString() );
        if(!W83bClsConstantes.VACIO.equals(cell.getStringCellValue()))
		{
	 		sheet.addMergedRegion(new Region(z,Short.parseShort("17"),z,Short.parseShort("18")));//NOPMD
		}
      //fin NUMERO LAudo
        
        //FECHA DE LAUDO
        row = sheet.getRow((short)z+2); 
        cell = row.createCell((short)3); 
        cell.setCellStyle(excel.styleTextoLabel);
        cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun","comun.impugnaciones.fLaudoabr"));
        cell = row.createCell((short)4); 
        cell.setCellStyle(excel.styleCadena9Justif);

        StringBuffer fechaLaudo = new StringBuffer();
        desde = false;
        if(StringUtils.isNotEmpty(impugnacionBean.getFechaLaudoDel())){
        	fechaLaudo.append(impugnacionBean.getFechaLaudoDel());
        	desde = true;
        }
        if(StringUtils.isNotEmpty(impugnacionBean.getFechaLaudoHasta())){
        	if(desde){
        		fechaLaudo.append(" - ");
        	}
        	fechaLaudo.append(impugnacionBean.getFechaLaudoHasta());
        }
        cell.setCellValue(fechaLaudo.toString());
        if(!W83bClsConstantes.VACIO.equals(cell.getStringCellValue()))
		{
	 		sheet.addMergedRegion(new Region(z+2,Short.parseShort("4"),z+2,Short.parseShort("6")));//NOPMD
		}
      //fin FECHA DE Laudo  
      //SIN FECHA DE LAUDO
        cell = row.createCell((short)7); 
        cell.setCellStyle(excel.styleTextoLabel);
        cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun","comun.impugnaciones.sinFechaLaudo"));
        cell = row.createCell((short)10);
        cell.setCellStyle(excel.styleCadena9Justif);
        String valor="";
        if(StringUtils.isNotEmpty(impugnacionBean.getSinFechaLaudo())){
        	
        	valor="X";
        }
        
        cell.setCellValue(valor);
        if(!W83bClsConstantes.VACIO.equals(cell.getStringCellValue()))
		{
	 		sheet.addMergedRegion(new Region(z+2,Short.parseShort("10"),z+2,Short.parseShort("13")));//NOPMD
		}
        //fin FECHA DE Laudo    
      //Resultado LAUDO
        row = sheet.getRow((short)z+2); 
        cell = row.createCell((short)14); 
        cell.setCellStyle(excel.styleTextoLabel);
        cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun","comun.impugnaciones.resultado"));
        cell = row.createCell((short)17); 
        cell.setCellStyle(excel.styleCadena9Justif);
        if(StringUtils.isNotEmpty(impugnacionBean.getResultadoTxt())){
        	cell.setCellValue(W83bUtilidadesExcel.mayusculasCampoExcel(impugnacionBean.getResultadoTxt()));
        }
        if(!W83bClsConstantes.VACIO.equals(cell.getStringCellValue()))
		{
	 		sheet.addMergedRegion(new Region(z+2,Short.parseShort("17"),z+2,Short.parseShort("18")));//NOPMD
		}
       
      //fin NUMERO LAudo
        
     

        
        //CENTRO TRABAJO        
        row = sheet.getRow((short)z+1); 
        cell = row.createCell((short)0); 
        cell.setCellStyle(excel.styleTextoLabel);
        cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun","comun.actas.rSocial"));
        
     
        cell = row.createCell((short)1);
        cell.setCellStyle(excel.styleCadena9Justif);
        if(StringUtils.isNotEmpty(impugnacionBean.getCentroTrabajo().getRazonSocial())){
        	cell.setCellValue(W83bUtilidadesExcel.mayusculasCampoExcel(impugnacionBean.getCentroTrabajo().getRazonSocial()));
        }
        if(!W83bClsConstantes.VACIO.equals(cell.getStringCellValue().trim()))
		{
	 		sheet.addMergedRegion(new Region(z+1,Short.parseShort("1"),z+1,Short.parseShort("2")));//NOPMD
		}
        cell = row.createCell((short)3); 
        cell.setCellStyle(excel.styleTextoLabel);
        cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun","comun.herramientas.cif"));
        cell = row.createCell((short)4);    
        cell.setCellStyle(excel.styleCadena9Justif);
        if(StringUtils.isNotEmpty(impugnacionBean.getCentroTrabajo().getCifnif()) && 
        		StringUtils.isNotEmpty(impugnacionBean.getCentroTrabajo().getNumCentro())){
        	cell.setCellValue(W83bUtilidadesExcel.mayusculasCampoExcel(impugnacionBean.getCentroTrabajo().getCifnif()+ " "+ impugnacionBean.getCentroTrabajo().getNumCentro()));
        }
        if(!W83bClsConstantes.VACIO.equals(cell.getStringCellValue()))
		{
	 		sheet.addMergedRegion(new Region(z+1,Short.parseShort("4"),z+1,Short.parseShort("6")));//NOPMD
		}
        cell = row.createCell((short)7); 
        cell.setCellStyle(excel.styleTextoLabel);
        cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun","comun.impugnaciones.provincia"));
        cell = row.createCell((short)10);        
        cell.setCellStyle(excel.styleCadena9Justif);
        if(StringUtils.isNotEmpty(impugnacionBean.getCentroTrabajo().getTerritorio())){
        	cell.setCellValue(W83bUtilidadesExcel.mayusculasCampoExcel(impugnacionBean.getCentroTrabajo().getTerritorio()));
        }
        if(!W83bClsConstantes.VACIO.equals(cell.getStringCellValue()))
		{
	 		sheet.addMergedRegion(new Region(z+1,Short.parseShort("10"),z+1,Short.parseShort("13")));//NOPMD
		}
        cell = row.createCell((short)14); 
        cell.setCellStyle(excel.styleTextoLabel);
        cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun","comun.impugnaciones.municipio"));
        cell = row.createCell((short)17); 
        cell.setCellStyle(excel.styleCadena9Justif);
        if(StringUtils.isNotEmpty(impugnacionBean.getCentroTrabajo().getMunicipio())){
        	cell.setCellValue(W83bUtilidadesExcel.mayusculasCampoExcel(impugnacionBean.getCentroTrabajo().getMunicipio()));
        }
        if(!W83bClsConstantes.VACIO.equals(cell.getStringCellValue()))
		{
	 		sheet.addMergedRegion(new Region(z+1,Short.parseShort("17"),z+1,Short.parseShort("18")));//NOPMD
		}
        //fin CENTRO TRABAJO        
        
        
        
       //Sindicato
         row = sheet.getRow((short)z+5); 
         cell = row.createCell((short)0); 
         cell.setCellStyle(excel.styleTextoLabel);
         cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun","comun.impugnaciones.sindicato"));
         
         cell = row.createCell((short)1);  
         cell.setCellStyle(excel.styleCadena9Justif);
         if(StringUtils.isNotEmpty(impugnacionBean.getSindicatoTxt())){
        	 cell.setCellValue(W83bUtilidadesExcel.mayusculasCampoExcel(impugnacionBean.getSindicatoTxt()));
         }	 
         if(!W83bClsConstantes.VACIO.equals(cell.getStringCellValue()))
 		{
 	 		sheet.addMergedRegion(new Region(z+5,Short.parseShort("1"),z+5,Short.parseShort("2")));//NOPMD
 		}
        //fin sindicado
         
         //Tipo voz
         cell = row.createCell((short)3); 
         cell.setCellStyle(excel.styleTextoLabel);
         cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun","comun.impugnaciones.tipoVoz"));
         
         cell = row.createCell((short)4); 
         cell.setCellStyle(excel.styleCadena9Justif);
         if(StringUtils.isNotEmpty(impugnacionBean.getTipoVozTxt())){
        	 cell.setCellValue(W83bUtilidadesExcel.mayusculasCampoExcel(impugnacionBean.getTipoVozTxt()));
         }
         if(!W83bClsConstantes.VACIO.equals(cell.getStringCellValue()))
  		{
  	 		sheet.addMergedRegion(new Region(z+5,Short.parseShort("4"),z+5,Short.parseShort("6")));//NOPMD
  		}
        //fin tipo voz
       // voz 
         cell = row.createCell((short)7); 
         cell.setCellStyle(excel.styleTextoLabel);
         cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun","comun.impugnaciones.voz"));
         
         cell = row.createCell((short)10);
         cell.setCellStyle(excel.styleCadena9Justif);
         if(StringUtils.isNotEmpty(impugnacionBean.getVozTxt())){
        	 cell.setCellValue(W83bUtilidadesExcel.mayusculasCampoExcel(impugnacionBean.getVozTxt()));
         }
         if(!W83bClsConstantes.VACIO.equals(cell.getStringCellValue()))
  		{
  	 		sheet.addMergedRegion(new Region(z+5,Short.parseShort("10"),z+5,Short.parseShort("13")));//NOPMD
  		}
        //fin voz
         // voz 
         cell = row.createCell((short)14); 
         cell2 = row.createCell((short)15);
         cell3 = row.createCell((short)16); 
         sheet.addMergedRegion(new Region(z+5,Short.parseShort("14"),z+5,Short.parseShort("16")));//NOPMD
         cell.setCellStyle(excel.styleTextoLabel);
         cell2.setCellStyle(excel.styleTextoLabel);
         cell3.setCellStyle(excel.styleTextoLabel);
         cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.herramientas.si",W83bClsConstantes.CONSTANTE_CASTELLANO).concat("/").concat(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.herramientas.no",W83bClsConstantes.CONSTANTE_CASTELLANO)).concat(" / ").concat(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.herramientas.si",W83bClsConstantes.CONSTANTE_EUSKARA).concat("/").concat(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.herramientas.no",W83bClsConstantes.CONSTANTE_EUSKARA))));
         
         cell = row.createCell((short)17);
         cell.setCellStyle(excel.styleCadena9Justif);
         if(StringUtils.isNotEmpty(impugnacionBean.getVozSINOTxt())){
        	 cell.setCellValue(W83bUtilidadesExcel.mayusculasCampoExcel(impugnacionBean.getVozSINOTxt()));
         }
         if(!W83bClsConstantes.VACIO.equals(cell.getStringCellValue()))
   		{
   	 		sheet.addMergedRegion(new Region(z+5,Short.parseShort("17"),z+5,Short.parseShort("18")));//NOPMD
   		}
        //fin voz
         
         
         //Arbitro
         row = sheet.getRow((short)z+3); 
         cell = row.createCell((short)7); 
         cell.setCellStyle(excel.styleTextoLabel);
         cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun","comun.impugnaciones.arbitro"));
         
         cell = row.createCell((short)10); 
         cell.setCellStyle(excel.styleCadena9Justif);
         if(StringUtils.isNotEmpty(impugnacionBean.getArbitroTxt())){
        	 cell.setCellValue(W83bUtilidadesExcel.mayusculasCampoExcel(impugnacionBean.getArbitroTxt()));
         }
         if(!W83bClsConstantes.VACIO.equals(cell.getStringCellValue()))
  		{
  	 		sheet.addMergedRegion(new Region(z+3,Short.parseShort("10"),z+3,Short.parseShort("13")));//NOPMD
  		}
        //fin sindicado
         
         
      
         //Tramite
         row = sheet.getRow((short)z+4); 
         cell = row.createCell((short)7); 
         cell.setCellStyle(excel.styleTextoLabel);
         cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun","comun.impugnaciones.tramite"));
         
         cell = row.createCell((short)10);
         cell.setCellStyle(excel.styleCadena9Justif);
         if(StringUtils.isNotEmpty(impugnacionBean.getTramiteTxt())){
        	 cell.setCellValue(W83bUtilidadesExcel.mayusculasCampoExcel(impugnacionBean.getTramiteTxt()));
         }
         if(!W83bClsConstantes.VACIO.equals(cell.getStringCellValue()))
   		{
   	 		sheet.addMergedRegion(new Region(z+4,Short.parseShort("10"),z+4,Short.parseShort("20")));//NOPMD
   		}
        //fin Tramite
         
         //FechaTramite
         row = sheet.getRow((short)z+4); 
         cell = row.createCell((short)0); 
         cell.setCellStyle(excel.styleTextoLabel);
         cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun","comun.actas.fTramDH"));
         cell = row.createCell((short)1);        
         cell.setCellStyle(excel.styleCadena9Justif);
         StringBuffer fechaTramite = new StringBuffer();
         desde = false;
         if(StringUtils.isNotEmpty(impugnacionBean.getFechaTramiteDel())){
        	 fechaTramite.append(impugnacionBean.getFechaTramiteDel());
         	desde = true;
         }
         if(StringUtils.isNotEmpty(impugnacionBean.getFechaTramiteHasta())){
         	if(desde){
         		fechaTramite.append(" - ");
         	}
         	fechaTramite.append(impugnacionBean.getFechaTramiteHasta());
         }
         cell.setCellValue(fechaTramite.toString());
         if(!W83bClsConstantes.VACIO.equals(cell.getStringCellValue()))
    		{
    	 		sheet.addMergedRegion(new Region(z+4,Short.parseShort("1"),z+4,Short.parseShort("2")));//NOPMD
    		}
        
        //fin FechaTramite
         
         //Ultimo tramite
         row = sheet.getRow((short)z+4); 
         cell = row.createCell((short)3); 
         cell.setCellStyle(excel.styleTextoLabel);
         cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun","comun.impugnaciones.ultimoTramite"));
         
         cell = row.createCell((short)4);   
         cell.setCellStyle(excel.styleCadena9Justif);
         valor="";
         if(StringUtils.isNotEmpty(impugnacionBean.getUltTramite())){
         	
         	valor="X";
         }
         
         cell.setCellValue(valor);
         if(!W83bClsConstantes.VACIO.equals(cell.getStringCellValue()))
    		{
    	 		sheet.addMergedRegion(new Region(z+4,Short.parseShort("4"),z+4,Short.parseShort("6")));//NOPMD
    		}
        //fin Ultimo tramite
        
      //FECHA DE EnvioArbitro
        row = sheet.getRow((short)z+3); 
        cell = row.createCell((short)0);
        cell.setCellStyle(excel.styleTextoLabel);
        cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun","comun.impugnaciones.fEnvArbabr"));
        cell = row.createCell((short)1); 
        cell.setCellStyle(excel.styleCadena9Justif);

        StringBuffer fechaEnvioArbitro = new StringBuffer();
        desde = false;
        if(StringUtils.isNotEmpty(impugnacionBean.getFechaEnvioArbitroDel())){
        	fechaEnvioArbitro.append(impugnacionBean.getFechaEnvioArbitroDel());
        	desde = true;
        }
        if(StringUtils.isNotEmpty(impugnacionBean.getFechaEnvioArbitroHasta())){
        	if(desde){
        		fechaEnvioArbitro.append(" - ");
        	}
        	fechaEnvioArbitro.append(impugnacionBean.getFechaEnvioArbitroHasta());
        }
        cell.setCellValue(fechaEnvioArbitro.toString());
        if(!W83bClsConstantes.VACIO.equals(cell.getStringCellValue()))
   		{
   	 		sheet.addMergedRegion(new Region(z+3,Short.parseShort("1"),z+3,Short.parseShort("2")));//NOPMD
   		}
        //SIn FECHA DE envio
        row = sheet.getRow((short)z+3); 
        cell = row.createCell((short)3); 
     
        cell.setCellStyle(excel.styleTextoLabel);
        cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun","comun.impugnaciones.sinFarbabr"));
        cell = row.createCell((short)4); 
        cell.setCellStyle(excel.styleCadena9Justif);
         valor="";
        if(StringUtils.isNotEmpty(impugnacionBean.getSinFechaEnvioArbitro())){
        	
        	valor="X";
        }
        
        cell.setCellValue(valor);
        if(!W83bClsConstantes.VACIO.equals(cell.getStringCellValue()))
   		{
   	 		sheet.addMergedRegion(new Region(z+3,Short.parseShort("4"),z+3,Short.parseShort("6")));//NOPMD
   		}
      //fin FECHA DE EnvioArbitro   
        //FECHA DE Desestimiento
        row = sheet.getRow((short)z+3); 
        cell = row.createCell((short)14); 
        cell.setCellStyle(excel.styleTextoLabel);
        cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun","comun.impugnaciones.fDesesabr"));
        cell = row.createCell((short)17);        
        cell.setCellStyle(excel.styleCadena9Justif);
        StringBuffer fechaDesestimiento = new StringBuffer();
        desde = false;
        if(StringUtils.isNotEmpty(impugnacionBean.getFechaDesestimientoDel())){
        	fechaDesestimiento.append(impugnacionBean.getFechaDesestimientoDel());
        	desde = true;
        }
        if(StringUtils.isNotEmpty(impugnacionBean.getFechaDesestimientoHasta())){
        	if(desde){
        		fechaDesestimiento.append(" - ");
        	}
        	fechaDesestimiento.append(impugnacionBean.getFechaDesestimientoHasta());
        }
        cell.setCellValue(fechaDesestimiento.toString());
        if(!W83bClsConstantes.VACIO.equals(cell.getStringCellValue()))
   		{
   	 		sheet.addMergedRegion(new Region(z+3,Short.parseShort("17"),z+3,Short.parseShort("18")));//NOPMD
   		}
        
      //fin FECHA DE desestimiento   
     
        //SIn FECHA DE laudo
        row = sheet.getRow((short)z+2); 
        cell = row.createCell((short)7); 
        cell.setCellStyle(excel.styleTextoLabel);
        cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun","comun.impugnaciones.sinFechaLaudo"));
        cell = row.createCell((short)10);  
        cell.setCellStyle(excel.styleCadena9Justif);
         valor="";
        if(StringUtils.isNotEmpty(impugnacionBean.getSinFechaLaudo())){
        	
        	valor="X";
        }
        
        
        cell.setCellValue(valor);
        if(!W83bClsConstantes.VACIO.equals(cell.getStringCellValue()))
   		{
   	 		sheet.addMergedRegion(new Region(z+2,Short.parseShort("10"),z+2,Short.parseShort("13")));//NOPMD
   		}
      //fin FECHA DE EnvioArbitro   
        

        
        //Creamos la cabecera de la tabla
        //El ancho de las columnas se han hallado con la formula (20*tamnyo columna en chars)/(1/20)
        row = sheet.getRow((short)z+8); // Creacin de la fila 1
        cell = row.getCell((short)0); // Creacin de la columna 1 para la fila 1
        cell.setCellStyle(excel.styleTextoLabelCentrado);
        cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.impugnaciones.nImpugnacion",W83bClsConstantes.CONSTANTE_EUSKARA)+"/ "+Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.impugnaciones.nImpugnacion",W83bClsConstantes.CONSTANTE_CASTELLANO));
        
        cell = row.getCell((short)1); // Creacin de la columna 1 para la fila 1
        cell.setCellStyle(excel.styleTextoLabelCentrado);
        cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.impugnaciones.nPreaviso",W83bClsConstantes.CONSTANTE_EUSKARA)+"/ "+Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.impugnaciones.nPreaviso",W83bClsConstantes.CONSTANTE_CASTELLANO));
        
        cell = row.getCell((short)2); // Creacin de la columna 1 para la fila 1
        cell.setCellStyle(excel.styleTextoLabelCentrado);
        cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.impugnaciones.nActa",W83bClsConstantes.CONSTANTE_EUSKARA)+"/ "+Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.impugnaciones.nActa",W83bClsConstantes.CONSTANTE_CASTELLANO));
        
        
        cell = row.getCell((short)3); // Creacin de la columna 1 para la fila 1
        cell.setCellStyle(excel.styleTextoLabelCentrado);
        cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.impugnaciones.fechaImpugnacionExcel",W83bClsConstantes.CONSTANTE_EUSKARA)+"/ "+Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.impugnaciones.fechaImpugnacionExcel",W83bClsConstantes.CONSTANTE_CASTELLANO));
        
        
        cell = row.getCell((short)4); // Creacin de la columna 1 para la fila 1
        cell.setCellStyle(excel.styleTextoLabelCentrado);
        cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.impugnaciones.arbitro",W83bClsConstantes.CONSTANTE_EUSKARA)+"/ "+Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.impugnaciones.arbitro",W83bClsConstantes.CONSTANTE_CASTELLANO));
        
        cell = row.getCell((short)6); // Creacin de la columna 1 para la fila 1
        cell.setCellStyle(excel.styleTextoLabelCentrado);
        cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.impugnaciones.fechaEnvioArbitroExcelExtraCorto",W83bClsConstantes.CONSTANTE_EUSKARA)+"/ "+Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.impugnaciones.fechaEnvioArbitroExcelExtraCorto",W83bClsConstantes.CONSTANTE_CASTELLANO));
       
        cell = row.getCell((short)7); // Creacin de la columna 1 para la fila 1
        cell.setCellStyle(excel.styleTextoLabelCentrado);
        cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.impugnaciones.fechaDesestimientoExcelExtraCorto",W83bClsConstantes.CONSTANTE_EUSKARA)+"/ "+Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.impugnaciones.fechaDesestimientoExcelExtraCorto",W83bClsConstantes.CONSTANTE_CASTELLANO));
       
        cell = row.getCell((short)10); // Creacin de la columna 1 para la fila 1
        cell.setCellStyle(excel.styleTextoLabelCentrado);
        cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.impugnaciones.nLaudo",W83bClsConstantes.CONSTANTE_EUSKARA)+"/ "+Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.impugnaciones.nLaudo",W83bClsConstantes.CONSTANTE_CASTELLANO));
        
        
        cell = row.getCell((short)12); // Creacin de la columna 1 para la fila 1
        cell.setCellStyle(excel.styleTextoLabelCentrado);;
        cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.impugnaciones.fechaLaudoExcel",W83bClsConstantes.CONSTANTE_EUSKARA)+"/ "+Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.impugnaciones.fechaLaudoExcel",W83bClsConstantes.CONSTANTE_CASTELLANO));
        

        
        cell = row.getCell((short)14); // Creacin de la columna 1 para la fila 1
        cell.setCellStyle(excel.styleTextoLabelCentrado);
        cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.impugnaciones.resultado",W83bClsConstantes.CONSTANTE_EUSKARA)+"/ "+Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.impugnaciones.resultado",W83bClsConstantes.CONSTANTE_CASTELLANO));
        
        cell = row.getCell((short)16); // Creacin de la columna 1 para la fila 1
        cell.setCellStyle(excel.styleTextoLabelCentrado);
        cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.impugnaciones.impugEmpresaExcel",W83bClsConstantes.CONSTANTE_EUSKARA)+"/ "+Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.impugnaciones.impugEmpresaExcel",W83bClsConstantes.CONSTANTE_CASTELLANO));
        
       
        cell = row.getCell((short)17); // Creacin de la columna 1 para la fila 1
        cell.setCellStyle(excel.styleTextoLabelCentrado);
        cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.impugnaciones.impugSindicatos",W83bClsConstantes.CONSTANTE_EUSKARA)+"/ "+Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.impugnaciones.impugSindicatos",W83bClsConstantes.CONSTANTE_CASTELLANO));
        
        cell = row.getCell((short)18); // Creacin de la columna 1 para la fila 1
        cell.setCellStyle(excel.styleTextoLabelCentrado);
        cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.preavisos.tabla.razon_social",W83bClsConstantes.CONSTANTE_EUSKARA)+"/ "+Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.preavisos.tabla.razon_social",W83bClsConstantes.CONSTANTE_CASTELLANO));
        
        
        
        if(null!=lista){
	        for(int i=0;i<lista.size();i++){
	        	row = sheet.createRow((short)z+9+i); // Creacin de la fila 1
	        	
	        	
	        	//Numero Impugnacion
	        	cell = row.createCell((short)0); 
	        	if(StringUtils.isNotEmpty(((W83bImpugnacionBean)lista.get(i)).getNImpugnacion())){
	        		cell.setCellValue(((W83bImpugnacionBean)lista.get(i)).getNImpugnacion());
	        	}
	        	cell.setCellStyle(estiloFilaCentrado(i,excel));
	        	
	        	//Numero Preaviso
	        	cell = row.createCell((short)1); 
	        	if(StringUtils.isNotEmpty(((W83bImpugnacionBean)lista.get(i)).getNPreaviso())){
	        		cell.setCellValue(((W83bImpugnacionBean)lista.get(i)).getNPreaviso());
	        	}
	        	cell.setCellStyle(estiloFilaCentrado(i,excel));
	        	
	        	//Numero Acta
	        	cell = row.createCell((short)2); 
	        	if(StringUtils.isNotEmpty(((W83bImpugnacionBean)lista.get(i)).getNActa())){
	        		cell.setCellValue(((W83bImpugnacionBean)lista.get(i)).getNActa());
	        	}
	        	cell.setCellStyle(estiloFilaCentrado(i,excel));
	        	
	        	// getFImpugnacion
	        	cell = row.createCell((short)3); 
	        	if(StringUtils.isNotEmpty(((W83bImpugnacionBean)lista.get(i)).getFImpugnacion())){
	        		cell.setCellValue(((W83bImpugnacionBean)lista.get(i)).getFImpugnacion());
	        	}
	        	cell.setCellStyle(estiloFilaCentrado(i,excel));
	        	
	        	// getArbitro
	        	sheet.addMergedRegion(new Region(z+9+i,Short.parseShort("4"),z+9+i,Short.parseShort("5")));//NOPMD
	        	cell = row.createCell((short)4); 
	        	if(StringUtils.isNotEmpty(((W83bImpugnacionBean)lista.get(i)).getArbitro())){
	        		cell.setCellValue(W83bUtilidadesExcel.mayusculasCampoExcel(((W83bImpugnacionBean)lista.get(i)).getArbitro()));
	        	}
	        	cell.setCellStyle(estiloFilaCentrado(i,excel));
	        	cell = row.createCell((short)5);
	        	cell.setCellStyle(estiloFilaCentrado(i,excel));
	        	
	        	// getArbitroFecha
	        	cell = row.createCell((short)6);
	        	if(StringUtils.isNotEmpty(((W83bImpugnacionBean)lista.get(i)).getFechaEnvioArbitro())){
	        		cell.setCellValue(W83bUtilidadesExcel.mayusculasCampoExcel(((W83bImpugnacionBean)lista.get(i)).getFechaEnvioArbitro()));
	        	}
	        	
	        	cell.setCellStyle(estiloFilaCentrado(i,excel));
	        	// getFechaDesestimiento
	        	sheet.addMergedRegion(new Region(z+9+i,Short.parseShort("7"),z+9+i,Short.parseShort("9")));//NOPMD
	        	cell = row.createCell((short)7); 
	        	if(StringUtils.isNotEmpty(((W83bImpugnacionBean)lista.get(i)).getFechaDesestimiento())){
	        		cell.setCellValue(W83bUtilidadesExcel.mayusculasCampoExcel(((W83bImpugnacionBean)lista.get(i)).getFechaDesestimiento()));
	        	}
	        	cell.setCellStyle(estiloFilaCentrado(i,excel));
	        	cell = row.createCell((short)8);
	        	cell.setCellStyle(estiloFilaCentrado(i,excel));
	        	cell = row.createCell((short)9);
	        	cell.setCellStyle(estiloFilaCentrado(i,excel));
	        	// getNLaudo
	        	sheet.addMergedRegion(new Region(z+9+i,Short.parseShort("10"),z+9+i,Short.parseShort("11")));//NOPMD
	        	cell = row.createCell((short)10); 
	        	if(StringUtils.isNotEmpty(((W83bImpugnacionBean)lista.get(i)).getNLaudo())){
	        		cell.setCellValue(W83bUtilidadesExcel.mayusculasCampoExcel(((W83bImpugnacionBean)lista.get(i)).getNLaudo()));
	        	}
	        	cell.setCellStyle(estiloFilaCentrado(i,excel));
	        	cell = row.createCell((short)11);
	        	cell.setCellStyle(estiloFilaCentrado(i,excel));
	        	
	        	// getFLaudo
	        	sheet.addMergedRegion(new Region(z+9+i,Short.parseShort("12"),z+9+i,Short.parseShort("13")));//NOPMD
	        	cell = row.createCell((short)12); 
	        	if(StringUtils.isNotEmpty(((W83bImpugnacionBean)lista.get(i)).getFLaudo())){
	        		cell.setCellValue(((W83bImpugnacionBean)lista.get(i)).getFLaudo());
	        	}
	        	cell.setCellStyle(estiloFilaCentrado(i,excel));
	        	cell = row.createCell((short)13);
	        	cell.setCellStyle(estiloFilaCentrado(i,excel));
	        	// getResultado
	        	sheet.addMergedRegion(new Region(z+9+i,Short.parseShort("14"),z+9+i,Short.parseShort("15")));//NOPMD
	        	cell = row.createCell((short)14); 
	        	if(StringUtils.isNotEmpty(((W83bImpugnacionBean)lista.get(i)).getDescresultado())){
	        		cell.setCellValue(W83bUtilidadesExcel.mayusculasCampoExcel(((W83bImpugnacionBean)lista.get(i)).getDescresultado()));
	        	}
	        	cell.setCellStyle(estiloFila(i,excel));
	        	cell = row.createCell((short)15);
	        	cell.setCellStyle(estiloFilaCentrado(i,excel));
	        	
	        	// getEmpresa
	        	cell = row.createCell((short)16); 
	        	if(StringUtils.isNotEmpty(((W83bImpugnacionBean)lista.get(i)).getDniImpug())){
	        		cell.setCellValue(W83bUtilidadesExcel.mayusculasCampoExcel(((W83bImpugnacionBean)lista.get(i)).getDniImpug()));
	        	}
	        	cell.setCellStyle(estiloFilaCentrado(i,excel));
	        	
	        	// getSindicatos
	        	cell = row.createCell((short)17); 
	        	if(StringUtils.isNotEmpty(((W83bImpugnacionBean)lista.get(i)).getAbrSindicatos())){
	        		cell.setCellValue(W83bUtilidadesExcel.mayusculasCampoExcel(((W83bImpugnacionBean)lista.get(i)).getAbrSindicatos()));
	        	}
	        	cell.setCellStyle(estiloFilaCentrado(i,excel));
	        	
	        	sheet.addMergedRegion(new Region(z+9+i,Short.parseShort("18"),z+9+i,Short.parseShort("20")));//NOPMD
	        	cell = row.createCell((short)18); 
	        	if(StringUtils.isNotEmpty(((W83bImpugnacionBean)lista.get(i)).getRazonsocial())){
	        		cell.setCellValue(W83bUtilidadesExcel.mayusculasCampoExcel(((W83bImpugnacionBean)lista.get(i)).getRazonsocial()));
	        	}
	        	cell.setCellStyle(estiloFilaCentrado(i,excel));
	        	cell = row.createCell((short)19);
	        	cell.setCellStyle(estiloFilaCentrado(i,excel));
	        	cell = row.createCell((short)20);
	        	cell.setCellStyle(estiloFilaCentrado(i,excel));
	        	
	        }
        }
        
        
		
        byte[] bytesExcel = W83bUtilidadesExcel.fncExcelToBytes(wb);
        response.setContentType("application/vnd.ms-excel");
        response.setContentLength(bytesExcel.length);
        response.setHeader("Content-disposition","attachment;filename=listadoImpugnaciones.xls");
        response.getOutputStream().write(bytesExcel);
        response.getOutputStream().flush();
        response.getOutputStream().close();

		
		
		return null;
	}
	
	private HSSFCellStyle estiloFila(int nFila, W83bUtilidadesExcel excel){
		if(nFila%2==0){
			return excel.styleTextoPar;
		}else{
			return excel.styleTextoImpar;			
		}
		
	}
	private HSSFCellStyle estiloFilaCentrado(int nFila, W83bUtilidadesExcel excel){
		if(nFila%2==0){
			return excel.styleTextoParCentrado;
		}else{
			return excel.styleTextoImparCentrado;			
		}
		
	}

}
